/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	AlchemyPot
**
** DESCRIPTION:	Alchemy pot puzzle
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef ALCHEMYPOT_H
#define ALCHEMYPOT_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwImage.h"
#include "PuzzleInterface.h"
#include "../Collectables/CollectableInterface.h"
#include "../Game/Potion.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const int AlchemyPot_c_iMaxRecipes = 100;
const int AlchemyPot_c_iNumIngredients = 3;
const int AlchemyPot_c_iNumHerbs = 7;

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CAlchemyPot : public IPuzzle, public ICollectable
{
	friend class CPuzzle;

private:

	//class structures
	struct SRecipe
	{
		int			m_iHashKey;
		EPotion		m_ePotion;
		ECarrying	m_eIngredient[AlchemyPot_c_iNumIngredients];
		bool		m_bHasMixed;
	};

	struct SSaveState
	{
		bool		m_bRecipeMixed[AlchemyPot_c_iMaxRecipes];
		int			m_iNumRecipes;
	};

	//class data
	ECarrying	m_eIngredient[AlchemyPot_c_iNumIngredients];
	int			m_iNumIngredients;

	SRecipe		m_sRecipe[AlchemyPot_c_iMaxRecipes];
	int			m_iNumRecipes;

	EPotion		m_ePotion;
	int			m_iPotSmoke;
	int			m_iPotEffect;

	bool		m_bPartialReset;

	//class methods
	//setup
	public:		CAlchemyPot(void);
	public:		void Reset();
	public:		void LoadAssets();
	public:		void ReleaseAssets();
	public:		const int LoadState(const unsigned char *pData);
	public:		const int SaveState(const unsigned char *pData, const int iMaxDataSize) const;

	// process
	public:     void ResetPotion();
	public:		void Refresh();
	public:		void Complete();
	public:		void Advance(CVillager &Villager, const int iRef);

	public:		const bool Carry(CVillager &Villager, const ECarrying eCarrying);
	public:		void Drop(CVillager &Villager, const ECarrying eCarrying);

	public:		void AddPotionEffect();
	public:		const int AddRecipe(const ECarrying eIngredient1, const ECarrying eIngredient2, const ECarrying eIngredient3, const EPotion ePotion);
	public:		const EPotion MixPotion(const ECarrying eIngredient1, const ECarrying eIngredient2, const ECarrying eIngredient3);
	public:		const int HashIngredients(const ECarrying eIngredient1, const ECarrying eIngredient2, const ECarrying eIngredient3) const;

	// access
	public:		const ECarrying GetNearbyCollectable(CVillager &Villager, const ldwPoint sPos);
	public:		const ECarrying GetIngredient(const int iIngredient) const { return m_eIngredient[iIngredient]; }
	public:		const int FindRecipe(const ECarrying eIngredient1, const ECarrying eIngredient2, const ECarrying eIngredient3) const;
	public:		const bool IsPotionReady() const;
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CAlchemyPot		AlchemyPot;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/